/*
 * Decompiled with CFR 0.152.
 */
package Entity.Enemies;

import Entity.Animation;
import Entity.Enemy;
import TileMap.TileMap;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;

public class Bandit
extends Enemy {
    private BufferedImage[] sprites;

    public Bandit(TileMap tm) {
        super(tm);
        this.moveSpeed = 0.2;
        this.maxSpeed = 0.5;
        this.fallSpeed = 0.3;
        this.maxFallSpeed = 0.5;
        this.width = 30;
        this.height = 30;
        this.cwidth = 20;
        this.cheight = 20;
        this.maxHealth = 3;
        this.health = 3;
        this.damage = 1;
        try {
            BufferedImage spritesheet = ImageIO.read(this.getClass().getResourceAsStream("/Sprites/Enemies/Bandit.png"));
            this.sprites = new BufferedImage[3];
            int i = 0;
            while (i < this.sprites.length) {
                this.sprites[i] = spritesheet.getSubimage(i * this.width, 0, this.width, this.height);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.animation = new Animation();
        this.animation.setFrames(this.sprites);
        this.animation.setDelay(300L);
        this.right = true;
    }

    private void getNextPosition() {
        if (this.left) {
            this.dx -= this.moveSpeed;
            if (this.dx < -this.maxSpeed) {
                this.dx = -this.maxSpeed;
            }
        } else if (this.right) {
            this.dx += this.moveSpeed;
            if (this.dx > this.maxSpeed) {
                this.dx = this.maxSpeed;
            }
        }
        if (this.falling) {
            this.dy += this.fallSpeed;
        }
    }

    @Override
    public void update() {
        long elapsed;
        this.getNextPosition();
        this.checkTileMapCollision();
        this.setPosition(this.xtemp, this.ytemp);
        if (this.flinching && (elapsed = (System.nanoTime() - this.flinchTimer) / 1000000L) > 400L) {
            this.flinching = false;
        }
        if (this.right && this.dx == 0.0) {
            this.right = false;
            this.left = true;
            this.facingRight = false;
        } else if (this.left && this.dx == 0.0) {
            this.right = true;
            this.left = false;
            this.facingRight = false;
        }
        this.animation.update();
    }

    @Override
    public void draw(Graphics2D graphics) {
        this.setMapPosition();
        super.draw(graphics);
    }
}

